;****************************************************************
;* MUSIC CD PLAYER - MuCoP					
;* BY KEITH WILSON					
;* VERSION 1						
;****************************************************************

;****************************************************************
;All global memory variables
;****************************************************************

AtaCounter			equ	0x20
AtaCommand			equ	0x21
AtaPacket			equ	0x22
AtaDataLsb			equ	0x30
AtaDataMsb			equ	0x31

KeyEvent				equ	0x34
KeyState				equ	0x35

;updated by ReadToc function
TrackFirstNr			equ	0x36
TrackLastNr			equ	0x37
TrackStartMSF_M		equ	0x38
TrackStartMSF_S		equ	0x39
TrackStartMSF_F		equ	0x3a
TrackLeadOutMSF_M		equ	0x3b
TrackLeadOutMSF_S		equ	0x3c
TrackLeadOutMSF_F		equ	0x3d

;updated by ReadSubChannel function
TrackCurrentNr		equ	0x44 ;initialise to 1 (default 1st track)
TrackCurrentMSF_M		equ	0x45
TrackCurrentMSF_S		equ	0x46
TrackCurrentMSF_F		equ	0x47
TrackStatus			equ	0x48

TrackTempNr			equ	0x49
TrackStartNr			equ	0x4a ;initialise to 1

AtaTemp				equ	0x4b
AtaReadBytesLsb		equ	0x4c
AtaReadBytesMsb		equ	0x4d

AdcMsb				equ	0x4e
AdcLsb				equ	0x4f

KeyEventTemp1			equ	0x50
KeyEventTemp2			equ	0x51

timera				equ	0x52
timerb				equ	0x53
timerc				equ	0x54
AtaRegister			equ	0x55
AtaErrorRetries		equ	0x56
;*******************
;PORT CONFIGURATIONS
;*******************
;analog key input, IDE control signals
PORTA_CONFIG1		equ	0x01	;bit5: out,out,out,out,out,in :bit0
ATA_IOW			equ	5
ATA_IOR			equ	4
ATA_A2			equ	3
ATA_A1			equ	2
ATA_A0			equ	1
KEYS				equ	0

;used as a bidirectional data bus for IDE_D00/D15
PORTB_CONFIG1		equ	0xff	;bit7: in,in,in,in,in,in,in,in :bit0
PORTC_CONFIG1		equ	0xff	;bit7: in,in,in,in,in,in,in,in :bit0
	
PORTB_CONFIG2		equ	0x00	;bit7: out,out,out,out,out,out,out,out :bit0
PORTC_CONFIG2		equ	0x00	;bit7: out,out,out,out,out,out,out,out :bit0


;lcd data bus D0/D4, IDE reset, status leds
PORTD_CONFIG1		equ	0x00	;bit7: out,in,out,out,out,out,out,out :bit0
ATA_RST			equ	7
LED_3			equ	6
LED_2			equ	5
LED_STATUS		equ	4

;lcd control signals
PORTE_CONFIG1		equ	0x00	;bit2: out,out,out :bit0
LCD_CLK			equ	2
LCD_RW			equ	1
LCD_RS			equ	0

;keypad events
KEY_EVENT_PLAY_STOP	equ	0
KEY_EVENT_NEXT		equ	1
KEY_EVENT_PREVIOUS	equ	2
KEY_EVENT_OPEN_CLOSE	equ	3
KEY_EVENT_PAUSE_ONOFF	equ	4
KEY_EVENT_LCD_INFO	equ	5

;key states (bit in variable KeyState)
KEY_STATE_PLAY_STOP		equ	0
KEY_STATE_PAUSE_ONOFF		equ	1
KEY_STATE_OPEN_CLOSE		equ	2


;keypad inputs voltages
;DigValue=(Vin*1023)/5
;KEYPAD_NO_KEY				equ	73	;msb=0,lsb=73	(0x49)	;<0,35V
;KEYPAD_PAUSE_ONOFF			equ	74	;msb=0,lsb=74(0x4a)	;0,36V-0,71V-1,06V
;KEYPAD_PREVIOUS				equ	219	;msb=0,lsb=219(0xdb)	;1,07V-1,43V-1,78V
;							equ	365	;msb=1,lsb=109(0x6d)
;KEYPAD_PLAY_STOP				equ	366	;msb=1,lsb=110(0x6e)	;1,79V-2,14V-2,49V
;KEYPAD_NEXT					equ	512	;msb=2,lsb=0			;2,50V-2,86V-3,20V
;KEYPAD_OPEN_CLOSE			equ	657	;msb=2,lsb=145(0x91)	;3,21V-3,57V-3,92V
;							equ	803	;msb=3,lsb=35(0x23)
;KEYPAD_LCD_INFO				equ	804	;msb=3,lsb=36(0x24)	;3,93V-4,29V-4,64V
;KEYPAD_MORE_THAN_ONE_KEY		equ	951	;msb=3,lsb=183(0xb7)	;>4,65V
